from openai import OpenAI
import httpx
import base64
import json
from config import model_name, log_file, API_KEY, ScanNet_Frame_ROOT

model = model_name  # like gpt-4o

def log_token_usage(response, used_model, lock, log_file=log_file):
    usage = response.usage
    log_entry = {
        "model": used_model,
        "prompt_tokens": usage.prompt_tokens,
        "completion_tokens": usage.completion_tokens,
        "total_tokens": usage.total_tokens
    }
    with lock:
        with open(log_file, "a") as f:
            f.write(json.dumps(log_entry) + "\n")

def encode_image(image_path):
    with open(image_path, "rb") as image_file:
        return base64.b64encode(image_file.read()).decode('utf-8')

def create_client(api_key):
    return OpenAI(api_key=api_key)

client = create_client(API_KEY)

def response_generator(system_text, user_text, image_path, max_token=1500, used_model=model, lock=None):
    if ScanNet_Frame_ROOT in image_path:
        base64_image = encode_image(image_path)
    else:
        base64_image = image_path

    completion = client.chat.completions.create(
        model=used_model,
        messages=[
            {
                "role": "system",
                "content": system_text
            },
            {
                "role": "user",
                "content": [
                {"type": "text", "text": user_text},
                {
                    "type": "image_url",
                    "image_url": {
                        "url": f"data:image/jpeg;base64,{base64_image}",
                    }
                },
            ],
            }
        ],
        max_tokens = max_token
    )

    response_message = completion.choices[0].message
    # print(response_message)
    if lock is not None:
        log_token_usage(completion, used_model, lock)
    return response_message


def response_generator_text(system_text, user_text, max_token=1300, used_model=model, lock=None):
    completion = client.chat.completions.create(
        model=used_model,
        messages=[
            {
                "role": "system",
                "content": system_text
            },
            {
                "role": "user",
                "content": [
                {"type": "text", "text": user_text}
            ],
            }
        ],
        max_tokens = max_token
    )

    response_message = completion.choices[0].message
    # print(response_message)
    if lock is not None:
        log_token_usage(completion, used_model, lock)
    return response_message
